/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.concurrent;

import io.gitlab.jfronny.commons.concurrent.ScopedValue;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.commons.throwable.Unchecked;
import org.jetbrains.annotations.ApiStatus;

public interface WithScopedValue<T> {
    @ApiStatus.Internal
    public ScopedValue<T> getAttached();

    @ApiStatus.Internal
    public T self();

    default public <TEx1 extends Throwable, TEx2 extends Throwable> void withContext(Action<TEx1, TEx2> action) throws TEx1, TEx2 {
        Unchecked.reintroduce();
        Unchecked.reintroduce(() -> ScopedValue.runWhere(this.getAttached(), this.self(), action.assumeSafe()));
    }

    default public <T, TEx1 extends Throwable, TEx2 extends Throwable> T withContext(Returnable<T, TEx1, TEx2> action) throws TEx1, TEx2 {
        Unchecked.reintroduce();
        return (T)Unchecked.reintroduce(() -> ScopedValue.getWhere(this.getAttached(), this.self(), action.assumeSafe()));
    }

    public static interface Action<TEx1 extends Throwable, TEx2 extends Throwable>
    extends ThrowingRunnable<Throwable> {
        @Override
        public void run() throws TEx1, TEx2;
    }

    public static interface Returnable<T, TEx1 extends Throwable, TEx2 extends Throwable>
    extends ThrowingSupplier<T, Throwable> {
        public T run() throws TEx1, TEx2;

        @Override
        default public T get() throws Throwable {
            return this.run();
        }
    }
}

